from GamePlay import PYBaseGamePlay

import GEEntity, GEPlayer, GEUtil, GEWeapon, GEMPGameRules, GEGlobal

#Your weapons are INVINCIBLE! Alas, you are not...

class TurboLTK(PYBaseGamePlay):
	def __init__(self):
		super(TurboLTK, self).__init__()

	def GetPrintName(self):
		return "TurboLTK"
		
	def GetHelpString(self):
		return "#GES_GP_LTK_HELP"
		
	def GetGameDescription(self):
		if GEMPGameRules.IsTeamplay():
			return "Team TurboLTK"
		else:
			return "TurboLTK"

	def GetTeamPlay(self):
		return GEGlobal.TEAMPLAY_TOGGLE
		
	def OnLoadGamePlay(self):
		GEMPGameRules.SetAllowTeamSpawns( False )
		self.SetDamageMultiplier( 1000 )
		self.LoadConfig()
		self.CreateCVar("ge_velocity", "1.5", "Velocity (speed) multiplier, range from 0.5 to 1.5.")
		
	def OnUnloadGamePlay(self):
		self.SetDamageMultiplier( 1 )
	
	def OnPlayerSpawn(self, player):
		player.SetSpeedMultiplier( float(GEUtil.GetCVarValue("ge_velocity")) )
	
	def OnPlayerConnect(self, player):
		player.SetDamageMultiplier( 1000 )
	
	def OnRoundBegin(self):
		GEMPGameRules.ResetAllPlayersScores()
		
	def OnPlayerKilled(self, victim, killer, weapon):
		#what exactly got killed?
		if not victim:
			return
		
		#death by world
		if not killer:
			victim.IncrementScore( -1 )
			return
		
		if victim.GetIndex() == killer.GetIndex():
			killer.IncrementScore( -1 )
		elif GEMPGameRules.IsTeamplay() and killer.GetTeamNumber() == victim.GetTeamNumber():
			killer.IncrementScore( -1 )
		else:
			team = GEMPGameRules.GetTeam(killer.GetTeamNumber())
			team.IncrementRoundScore( 1 )
			killer.IncrementScore( 1 )

	def SetDamageMultiplier(self, amount):
		for i in range(32):
			if not GEUtil.IsValidPlayerIndex(i):
				continue
			player = GEUtil.GetMPPlayer(i)
			player.SetDamageMultiplier(amount)

	def OnCVarChanged(self, name, oldvalue, newvalue):
		if name == "ge_velocity":
			for i in range(32):
				if not GEUtil.IsValidPlayerIndex(i):
					continue
				player = GEUtil.GetMPPlayer(i)
				player.SetSpeedMultiplier( float(newvalue) )
